#include "g_local.h"
#include "ai_stripper.h"
#include "voice_bitch.h"

void stripper_sit_talk (edict_t *self);
void stripper_end_stand (edict_t *self);
void stripper_talk_think( edict_t *self );

void stripper_stand_onfire (edict_t *self, float dist);

mframe_t	stripper_frames_amb[] = 
{
	ai_stand,	  0.000, stripper_talk_think,	// frame 0
	ai_stand,	  0.000, stripper_talk_think,	// frame 1
	ai_stand,	  0.000, stripper_talk_think,	// frame 2
	ai_stand,	  0.000, stripper_talk_think,	// frame 3
	ai_stand,	  0.000, stripper_talk_think,	// frame 4
	ai_stand,	  0.000, stripper_talk_think,	// frame 5
	ai_stand,	  0.000, stripper_talk_think,	// frame 6
	ai_stand,	  0.000, stripper_talk_think,	// frame 7
	ai_stand,	  0.000, stripper_talk_think,	// frame 8
	ai_stand,	  0.000, stripper_talk_think,	// frame 9
	ai_stand,	  0.000, stripper_talk_think,	// frame 10
	ai_stand,	  0.000, stripper_talk_think,	// frame 11
	ai_stand,	  0.000, stripper_talk_think,	// frame 12
	ai_stand,	  0.000, stripper_talk_think,	// frame 13
	ai_stand,	  0.000, stripper_talk_think,	// frame 14
	ai_stand,	  0.000, stripper_talk_think,	// frame 15
	ai_stand,	  0.000, stripper_talk_think,	// frame 16
	ai_stand,	  0.000, stripper_talk_think,	// frame 17
	ai_stand,	  0.000, stripper_talk_think,	// frame 18
	ai_stand,	  0.000, stripper_talk_think,	// frame 19
	ai_stand,	  0.000, stripper_talk_think,	// frame 20
};
mmove_t	stripper_move_amb = {FRAME_frame_00, FRAME_frame_20, stripper_frames_amb, stripper_end_stand};

mframe_t	stripper_frames_strip[] = 
{
	ai_stand,	  0.000, stripper_talk_think,	// frame 0
	ai_stand,	  0.000, stripper_talk_think,	// frame 1
	ai_stand,	  0.000, stripper_talk_think,	// frame 2
	ai_stand,	  0.000, stripper_talk_think,	// frame 3
	ai_stand,	  0.000, stripper_talk_think,	// frame 4
	ai_stand,	  0.000, stripper_talk_think,	// frame 5
	ai_stand,	  0.000, stripper_talk_think,	// frame 6
	ai_stand,	  0.000, stripper_talk_think,	// frame 7
	ai_stand,	  0.000, stripper_talk_think,	// frame 8
	ai_stand,	  0.000, stripper_talk_think,	// frame 9
	ai_stand,	  0.000, stripper_talk_think,	// frame 10
	ai_stand,	  0.000, stripper_talk_think,	// frame 11
	ai_stand,	  0.000, stripper_talk_think,	// frame 12
	ai_stand,	  0.000, stripper_talk_think,	// frame 13
	ai_stand,	  0.000, stripper_talk_think,	// frame 14
	ai_stand,	  0.000, stripper_talk_think,	// frame 15
	ai_stand,	  0.000, stripper_talk_think,	// frame 16
	ai_stand,	  0.000, stripper_talk_think,	// frame 17
	ai_stand,	  0.000, stripper_talk_think,	// frame 18
	ai_stand,	  0.000, stripper_talk_think,	// frame 19
	ai_stand,	  0.000, stripper_talk_think,	// frame 20
	ai_stand,	  0.000, stripper_talk_think,	// frame 21
	ai_stand,	  0.000, stripper_talk_think,	// frame 22
	ai_stand,	  0.000, stripper_talk_think,	// frame 23
	ai_stand,	  0.000, stripper_talk_think,	// frame 24
	ai_stand,	  0.000, stripper_talk_think,	// frame 25
	ai_stand,	  0.000, stripper_talk_think,	// frame 26
	ai_stand,	  0.000, stripper_talk_think,	// frame 27
	ai_stand,	  0.000, stripper_talk_think,	// frame 28
	ai_stand,	  0.000, stripper_talk_think,	// frame 29
};
mmove_t	stripper_move_strip = {FRAME_strip_00, FRAME_strip_29, stripper_frames_strip, stripper_end_stand};
mframe_t	stripper_frames_strip_onfire[] = 
{
	stripper_stand_onfire,	  0.000, NULL,	// frame 0
	stripper_stand_onfire,	  0.000, NULL,	// frame 1
	stripper_stand_onfire,	  0.000, NULL,	// frame 2
	stripper_stand_onfire,	  0.000, NULL,	// frame 3
	stripper_stand_onfire,	  0.000, NULL,	// frame 4
	stripper_stand_onfire,	  0.000, NULL,	// frame 5
	stripper_stand_onfire,	  0.000, NULL,	// frame 6
	stripper_stand_onfire,	  0.000, NULL,	// frame 7
	stripper_stand_onfire,	  0.000, NULL,	// frame 8
	stripper_stand_onfire,	  0.000, NULL,	// frame 9
	stripper_stand_onfire,	  0.000, NULL,	// frame 10
	stripper_stand_onfire,	  0.000, NULL,	// frame 11
	stripper_stand_onfire,	  0.000, NULL,	// frame 12
	stripper_stand_onfire,	  0.000, NULL,	// frame 13
	stripper_stand_onfire,	  0.000, NULL,	// frame 14
	stripper_stand_onfire,	  0.000, NULL,	// frame 15
	stripper_stand_onfire,	  0.000, NULL,	// frame 16
	stripper_stand_onfire,	  0.000, NULL,	// frame 17
	stripper_stand_onfire,	  0.000, NULL,	// frame 18
	stripper_stand_onfire,	  0.000, NULL,	// frame 19
	stripper_stand_onfire,	  0.000, NULL,	// frame 20
	stripper_stand_onfire,	  0.000, NULL,	// frame 21
	stripper_stand_onfire,	  0.000, NULL,	// frame 22
	stripper_stand_onfire,	  0.000, NULL,	// frame 23
	stripper_stand_onfire,	  0.000, NULL,	// frame 24
	stripper_stand_onfire,	  0.000, NULL,	// frame 25
	stripper_stand_onfire,	  0.000, NULL,	// frame 26
	stripper_stand_onfire,	  0.000, NULL,	// frame 27
	stripper_stand_onfire,	  0.000, NULL,	// frame 28
	stripper_stand_onfire,	  0.000, NULL,	// frame 29
};
mmove_t	stripper_move_strip_onfire = {FRAME_strip_00, FRAME_strip_29, stripper_frames_strip_onfire, NULL};

void stripper_stand_onfire (edict_t *self, float dist)
{

	if (self->onfiretime <= 0)
	{	// stopping running around
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
	}

	if (!self->groundentity)
		return;

}
void stripper_talk_think (edict_t *self)
{
	AI_TalkThink (self, true);
}

void stripper_end_stand( edict_t *self )
{
	self->cast_info.currentmove = &stripper_move_amb;
}
void stripper_backoff( edict_t *self, edict_t *other )
{
	Voice_Random( self, other, f_backoff, F_NUM_BACKOFF );
}
void stripper_avoid (edict_t *self, edict_t *other, qboolean face)
{
	self->cast_info.currentmove = &stripper_move_strip;
}
void stripper_catch_on_fire (edict_t *self, edict_t *other)
{
	self->enemy = NULL;		// stop attacking
	self->cast_info.currentmove = &stripper_move_strip_onfire;
}
void stripper_sit_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	int i;
	vec3_t realorigin;

	VectorCopy(self->s.origin, realorigin);
	realorigin[2] += 8;

	for (i = 0; i < 20; i++)
	{
		realorigin[0] = (self->s.origin[0] + ((rand()&63) - 32));
		realorigin[1] = (self->s.origin[1] + ((rand()&63) - 31));			
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_GIBS);
		gi.WritePosition (realorigin);
		gi.WriteDir (vec3_origin);
		gi.WriteByte ( 2 );	// number of gibs
		gi.WriteByte ( 0 );	// scale of direction to add to velocity
		gi.WriteByte ( 0 );	// random offset scale
		gi.WriteByte ( 10 );	// random velocity scale
		gi.multicast (realorigin, MULTICAST_PVS);

		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_SPLASH);
		gi.WriteByte (4);
		gi.WritePosition (realorigin);
		gi.WriteDir (self->movedir);
		gi.WriteByte (6);
		gi.multicast (realorigin, MULTICAST_PVS);
	}

	if (self->item)
	{
		Drop_Item (self, self->item);
		self->item = NULL;
	}

	G_FreeEdict (self);
}
void stripper_pain (edict_t *self, edict_t *other, float kick, int damage, int mdx_part, int mdx_subobject)
{
	if (level.time < self->pain_debounce_time)
		return;
	if (self->health < (self->max_health / 2))
	

	self->pain_debounce_time = level.time + 3 + random();
	self->cast_info.currentmove = &stripper_move_strip;
	/*
	if (rand() % 100 > 50)
		gi.sound (self, CHAN_VOICE, gi.soundindex("actors/bitch/pain1.wav"), 1, ATTN_NORM, 0);
	else
		gi.sound (self, CHAN_VOICE, gi.soundindex("actors/bitch/pain2.wav"), 1, ATTN_NORM, 0);
	*/

	if (self->health < 25)
		Voice_Specific (self, other, female_specific, 4);
	else if (self->health < 50)
		Voice_Specific (self, other, female_specific, 3);
	else if (self->health < 75)
		Voice_Specific (self, other, female_specific, 2);
	else
		Voice_Specific (self, other, female_specific, 1);
}
void stripper_pickup_cash (edict_t *self)
{
	edict_t		*trav, *best;
	trav = best = NULL;
		// if the enemy has cash - then take it
		// Joseph 14-MAY-99
		if ((best) && (best->currentcash > 0) && best->health <= 0)
		// END JOSEPH
		{
			int     index;
			gitem_t *item;
			
			self->client->pers.currentcash += best->currentcash;
			//cprintf (ent, PRINT_HIGH, "%i dollars found\n", best->currentcash);
			self->client->ps.stats[STAT_CASH_PICKUP] = best->currentcash;
			best->currentcash = 0;
			// flash the screen green
			self->client->bonus_alpha = 0.25;	
			self->client->bonus_alpha_color = 2;	
			gi.sound (self, CHAN_AUTO, gi.soundindex("world/pickups/cash.wav"), 1, ATTN_NORM, 0);		

			item = FindItem ("Cash");
			index = ITEM_INDEX (item);


		}
}
/*QUAKED cast_stripper (1 .5 0) (-16 -16 -24) (16 16 48) x TRIGGERED_START x x x 
cast_group 0	neutral
They should only be neutrals
model="models\actors\stripper\"
*/
void SP_cast_stripper (edict_t *self)
{
	int i;
	int	skin;


	self->movetype = MOVETYPE_STEP;
	self->solid = SOLID_BBOX;
	VectorSet (self->mins, -16, -16, -24);
	VectorSet (self->maxs, 16, 16, 48);

	self->s.skinnum = (self->skin-1) * 3;
	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

	self->art_skins = NULL;

	self->s.num_parts++;
	self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/actors/stripper/stripper.mdx");
	skin = self->s.skinnum;
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_HEAD].baseskin = self->s.model_parts[PART_HEAD].skinnum[i] = skin;
	gi.GetObjectBounds( "models/actors/stripper/stripper.mdx", &self->s.model_parts[PART_HEAD] );

	if (!(self->health))
	self->health = 100;

	self->gib_health = -200;
	self->mass = 200;

	self->gender = GENDER_FEMALE;

	self->pain = stripper_pain; //FREDZ need fix
	self->die = stripper_sit_die; //FREDZ need fix

	self->cast_info.checkattack = NULL;

	self->cast_info.attack = NULL;
	self->cast_info.long_attack = NULL;
	self->cast_info.talk = stripper_end_stand;
	self->cast_info.avoid = stripper_avoid; //FREDZ need fix
	self->cast_info.backoff = stripper_backoff;

	self->cast_info.catch_fire = stripper_catch_on_fire; //FREDZ need fix

	self->cast_info.max_attack_distance = 64;

	self->cast_info.move_stand = &stripper_move_amb;
	self->cast_info.move_crstand = NULL;

	self->cast_info.move_run = NULL;
	self->cast_info.move_runwalk = NULL;
	self->cast_info.move_crwalk = NULL;

	self->cast_info.move_jump = NULL;

	self->cast_info.move_avoid_walk = NULL; 
	self->cast_info.move_avoid_run = NULL;
	self->cast_info.move_avoid_reverse_walk = NULL;
	self->cast_info.move_avoid_reverse_run = NULL;
	self->cast_info.move_avoid_crwalk = NULL;

	self->cast_info.move_crouch_down = NULL;
	self->cast_info.move_stand_up = NULL;
	self->cast_info.move_lside_step = NULL;
	self->cast_info.move_rside_step = NULL;
	self->cast_info.move_start_climb = NULL;
	self->cast_info.move_end_climb = NULL;
	self->cast_info.move_evade = NULL;
	self->cast_info.move_stand_evade = NULL; 

	gi.linkentity (self);

	self->cast_info.currentmove = self->cast_info.move_stand;


	if (!self->cast_info.scale)
		self->cast_info.scale = MODEL_SCALE;

	self->s.scale = self->cast_info.scale - 1.0;

	// talk by default
// 	self->cast_info.aiflags |= AI_NO_TALK;
	self->cast_info.aiflags |= (AI_TALK | AI_NOWALK_FACE);

	walking_cast_start (self);

}